<?php
include 'koneksi.php';
include 'header2.php'; 

// Cek sesi pengguna
$sesi = $_SESSION['level'];
if ($sesi == "") {
    header("location: login.php");
    exit;
}

// Ambil ID dari URL dengan validasi
$id = isset($_GET["id"]) ? (int)$_GET["id"] : 0;

// Ambil data channel berdasarkan ID
$query = "SELECT * FROM channel WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$channel = $result->fetch_assoc();

// **Jika data tidak ditemukan, tampilkan pesan error**
if (!$channel) {
    echo "<script>
        alert('Data tidak ditemukan!');
        window.location = 'tambah_channel.php';
    </script>";
    exit;
}

// Jika tombol submit ditekan (update data)
if (isset($_POST["submit"])) {
    $nama = $_POST["nama"];
    $views = $_POST["views"];
    $subscribers = $_POST["subscribers"];
    $frekuensi = $_POST["frekuensi"];
    $videos = $_POST["videos"];
    $background = $_POST["background"];

    // Update data
    $query = "UPDATE channel SET nama = ?, views = ?, subscribers = ?, frekuensi = ?, videos = ?, background = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("siiissi", $nama, $views, $subscribers, $frekuensi, $videos, $background, $id);

    if ($stmt->execute()) {
        echo "<script>
            alert('Data berhasil diubah!');
            window.location = 'channel.php';
        </script>";
    } else {
        echo "<script>alert('Data gagal diubah!');</script>";
    }
}

// Jika tombol hapus ditekan
if (isset($_POST["hapus"])) {
    $query = "DELETE FROM channel WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>
            alert('Data berhasil dihapus!');
            window.location = 'channel.php';
        </script>";
    } else {
        echo "<script>alert('Gagal menghapus data!');</script>";
    }
}
?>

<div id="layoutSidenav_content">
    <main>
    <div class="container-fluid mt-4">
        <h3 class="text-center mb-10 py-4 rounded" style="font-size: 28px;">
            <strong>Perbaharui Data Mahasiswa</strong>
        </h3>

        <br/>

        <div class="row justify-content-center">
            <div class='col-sm-12'>
                <form action="" method="post">
                    <input type="hidden" name="id" value="<?php echo $channel["id"]; ?>">
                    <table class='table table-bordered w-100' style="font-size: 18px;">
                        <tr style="height: 65px;">
                            <td class="text-center align-middle" style="width: 30%;"><strong>Nama Channel</strong></td>
                            <td><input name="alternatif" type='text' class='form-control' style="font-size: 18px; height: 50px;" value="<?php echo $channel["nama"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>Jumlah Views</strong></td>
                            <td><input type="text" name="nama" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $channel["views"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>Jumlah Subscribers</strong></td>
                            <td><input type="text" name="nim" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $channel["subscribers"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>Frekuensi Unggah Video</strong></td>
                            <td><input type="email" name="email" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $channel["frekuensi"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>Jumlah Video</strong></td>
                            <td><input type="email" name="email" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $channel["videos"]; ?>" required></td>
                        </tr>
                        <tr style="height: 65px;">
                            <td class="text-center align-middle"><strong>Latar Belakang Konten Kreator</strong></td>
                            <td><input type="email" name="email" class='form-control' style="font-size: 18px; height: 50px;" value="<?= $channel["background"]; ?>" required></td>
                        </tr>
                            <tr>
                                <td class="text-center" colspan="2">
                                    <button class="btn btn-success" type="submit" name="submit">
                                        <i class="fas fa-check"></i> Ubah Data
                                    </button>
                                    <button class="btn btn-danger" type="submit" name="hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                        <i class="fas fa-trash"></i> Hapus Data
                                    </button>
                                </td>
                            </tr>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </main>
</div>

<!-- Custom Style: Lebar dan Tinggi Tabel Lebih Luas -->
<style>
    .table {
        width: 100%;  /* Lebar penuh */
        margin-bottom: 20px;
    }
    .table td {
        height: 60px;  /* Tinggi antar baris lebih tinggi */
    }
</style>
